<?php
// Set headers for JSON API
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type');

require_once 'config.php';
require_once 'sheets_api.php';

// Initialize response array
$response = [
    'success' => false,
    'data' => null,
    'error' => null,
    'meta' => [
        'spreadsheet_id' => null,
        'sheet_name' => null,
        'timestamp' => date('Y-m-d H:i:s')
    ]
];

// Get parameters
$spreadsheetId = isset($_GET['spreadsheet_id']) ? $_GET['spreadsheet_id'] : '';
$sheetName = isset($_GET['sheet']) ? $_GET['sheet'] : 'Sheet1';

// Use config values if not provided
if (empty($spreadsheetId) && defined('SPREADSHEET_ID') && !empty(SPREADSHEET_ID)) {
    $spreadsheetId = SPREADSHEET_ID;
}

// Update meta information
$response['meta']['spreadsheet_id'] = $spreadsheetId;
$response['meta']['sheet_name'] = $sheetName;

try {
    // Validate spreadsheet ID
    if (empty($spreadsheetId)) {
        throw new Exception('Spreadsheet ID is required. Provide it in the URL (?spreadsheet_id=YOUR_ID) or in config.php');
    }
    
    // Get data from the sheet
    $range = urlencode($sheetName);
    $sheetData = getSheetData($spreadsheetId, $range);
    
    if (empty($sheetData)) {
        throw new Exception('No data found in the specified sheet');
    }
    
    // Process data into a more usable format
    $headers = $sheetData[0];
    $rows = [];
    
    for ($i = 1; $i < count($sheetData); $i++) {
        $row = [];
        foreach ($sheetData[$i] as $index => $cell) {
            if (isset($headers[$index])) {
                $row[$headers[$index]] = $cell;
            }
        }
        $rows[] = $row;
    }
    
    // Set success response
    $response['success'] = true;
    $response['data'] = [
        'headers' => $headers,
        'rows' => $rows,
        'raw' => $sheetData
    ];
    
} catch (Exception $e) {
    // Set error response
    $response['error'] = $e->getMessage();
}

// Output JSON response
echo json_encode($response, JSON_PRETTY_PRINT);
?>