<?php
// Google Sheets API Configuration
define('CREDENTIALS_FILE', __DIR__ . '/credentials.json');
define('TOKEN_FILE', __DIR__ . '/token.json');
define('SCOPES', ['https://www.googleapis.com/auth/spreadsheets.readonly']);

// Load credentials from file if it exists and has valid content
if (file_exists(CREDENTIALS_FILE) && filesize(CREDENTIALS_FILE) > 0) {
    $credentials = json_decode(file_get_contents(CREDENTIALS_FILE), true);
    
    // Check if credentials are valid (not placeholder values)
    if (isset($credentials['client_id']) && $credentials['client_id'] !== 'your-client-id') {
        // API Configuration from credentials file
        define('API_KEY', ''); // Optional: If you want to use API key instead of OAuth
        define('CLIENT_ID', $credentials['client_id']);
        define('CLIENT_EMAIL', $credentials['client_email']);
        define('PRIVATE_KEY', $credentials['private_key']);
    } else {
        // Placeholder values (will be replaced during setup)
        define('API_KEY', '');
        define('CLIENT_ID', 'your-client-id');
        define('CLIENT_EMAIL', 'your-service-account-email');
        define('PRIVATE_KEY', 'your-private-key');
    }
} else {
    // Placeholder values (will be replaced during setup)
    define('API_KEY', '');
    define('CLIENT_ID', 'your-client-id');
    define('CLIENT_EMAIL', 'your-service-account-email');
    define('PRIVATE_KEY', 'your-private-key');
}

// Spreadsheet Configuration
define('SPREADSHEET_ID', ''); // Will be set during setup
define('SHEET_NAME', 'Sheet1'); // Default sheet name
?>