<?php
// This script helps test if the setup process is working correctly

// Check the current state of credentials.json
echo "<h2>Current State of credentials.json:</h2>";
if (file_exists('credentials.json') && filesize('credentials.json') > 0) {
    $credentials = json_decode(file_get_contents('credentials.json'), true);
    if ($credentials === null) {
        echo "<p>credentials.json exists but contains invalid JSON.</p>";
    } else {
        echo "<p>credentials.json exists and contains valid JSON.</p>";
        
        if (isset($credentials['client_id']) && $credentials['client_id'] !== 'your-client-id') {
            echo "<p>credentials.json contains real credentials (client_id is not a placeholder).</p>";
        } else {
            echo "<p>credentials.json contains placeholder values (client_id is 'your-client-id').</p>";
        }
    }
} else {
    echo "<p>credentials.json does not exist or is empty.</p>";
}

// Check the current state of config.php
echo "<h2>Current State of config.php:</h2>";
if (file_exists('config.php')) {
    require_once 'config.php';
    
    echo "<p>CLIENT_ID: " . (defined('CLIENT_ID') ? CLIENT_ID : 'Not defined') . "</p>";
    echo "<p>CLIENT_EMAIL: " . (defined('CLIENT_EMAIL') ? CLIENT_EMAIL : 'Not defined') . "</p>";
    echo "<p>SPREADSHEET_ID: " . (defined('SPREADSHEET_ID') ? SPREADSHEET_ID : 'Not defined') . "</p>";
    
    if (defined('CLIENT_ID') && CLIENT_ID !== 'your-client-id') {
        echo "<p>config.php contains real credentials (CLIENT_ID is not a placeholder).</p>";
    } else {
        echo "<p>config.php contains placeholder values (CLIENT_ID is 'your-client-id').</p>";
    }
} else {
    echo "<p>config.php does not exist.</p>";
}

// Provide links to test the setup process
echo "<h2>Test Links:</h2>";
echo "<p><a href='index.php'>Go to index.php</a> - Should redirect to setup.php if setup is not complete</p>";
echo "<p><a href='setup.php'>Go to setup.php directly</a> - Should show setup form if setup is not complete</p>";

// Provide a reset option
echo "<h2>Reset Setup:</h2>";
echo "<p>To reset the setup and test again, you can:</p>";
echo "<ol>";
echo "<li>Replace credentials.json with placeholder values</li>";
echo "<li>Set \$forceSetup = true in index.php</li>";
echo "</ol>";

// Provide a button to reset credentials.json to placeholder values
if (isset($_POST['reset_credentials'])) {
    $placeholderJson = '{
  "type": "service_account",
  "project_id": "your-project-id",
  "private_key_id": "your-private-key-id",
  "private_key": "your-private-key",
  "client_email": "your-service-account-email",
  "client_id": "your-client-id",
  "auth_uri": "https://accounts.google.com/o/oauth2/auth",
  "token_uri": "https://oauth2.googleapis.com/token",
  "auth_provider_x509_cert_url": "https://www.googleapis.com/oauth2/v1/certs",
  "client_x509_cert_url": "your-client-x509-cert-url",
  "universe_domain": "googleapis.com"
}';
    file_put_contents('credentials.json', $placeholderJson);
    echo "<p>credentials.json has been reset to placeholder values. <a href='test_setup.php'>Refresh</a> to see the changes.</p>";
}
?>

<form method="post" action="">
    <button type="submit" name="reset_credentials">Reset credentials.json to placeholder values</button>
</form>