<?php
session_start();
require_once 'config.php';
require_once 'sheets_api.php';

// Simple user authentication (for demo purposes only)
// In a real application, you would use a secure authentication system
$demo_users = [
    '1' => ['password' => 'pass1', 'name' => 'John Doe'],
    '2' => ['password' => 'pass2', 'name' => 'Jane Smith'],
    '3' => ['password' => 'pass3', 'name' => 'Bob Johnson']
];

$error = '';
$message = '';

// Handle login
if (isset($_POST['login'])) {
    $username = isset($_POST['username']) ? $_POST['username'] : '';
    $password = isset($_POST['password']) ? $_POST['password'] : '';
    
    if (isset($demo_users[$username]) && $demo_users[$username]['password'] === $password) {
        $_SESSION['user_id'] = $username;
        $_SESSION['user_name'] = $demo_users[$username]['name'];
        
        // Redirect to avoid form resubmission
        header('Location: ' . $_SERVER['PHP_SELF'] . '?login_success=1');
        exit;
    } else {
        $error = "Invalid username or password";
    }
}

// Handle success message after redirect
if (isset($_GET['login_success'])) {
    $message = "Login successful!";
}

// Handle logout
if (isset($_GET['logout'])) {
    session_destroy();
    $_SESSION = [];
    $message = "You have been logged out.";
}

// Get user-specific data from Google Sheets
$userData = [];
$spreadsheetId = defined('SPREADSHEET_ID') && !empty(SPREADSHEET_ID) ? SPREADSHEET_ID : '';

if (isset($_SESSION['user_id']) && !empty($spreadsheetId)) {
    try {
        // Get all data from the sheet
        $sheetName = 'user_data'; // This would be your sheet containing user data
        $allData = getSheetData($spreadsheetId, $sheetName);
        
        if (!empty($allData)) {
            // Filter data for the specific user
            $headers = $allData[0];
            $userIdIndex = array_search('user_id', $headers);
            
            if ($userIdIndex !== false) {
                for ($i = 1; $i < count($allData); $i++) {
                    // Compare as strings to handle both numeric and string IDs
                    if (isset($allData[$i][$userIdIndex]) &&
                        (string)$allData[$i][$userIdIndex] === (string)$_SESSION['user_id']) {
                        $row = [];
                        foreach ($allData[$i] as $index => $cell) {
                            if (isset($headers[$index])) {
                                $row[$headers[$index]] = $cell;
                            }
                        }
                        $userData[] = $row;
                    }
                }
            } else {
                $error = "The sheet does not have a 'user_id' column for filtering.";
            }
        }
    } catch (Exception $e) {
        $error = "Error retrieving data: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User-Specific Data Example</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            padding: 20px;
            background-color: #f8f9fa;
        }
        .container {
            max-width: 1000px;
        }
        .card {
            margin-bottom: 20px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .login-form {
            max-width: 400px;
            margin: 0 auto;
        }
        .error {
            color: red;
        }
        .success {
            color: green;
        }
        .user-info {
            background-color: #e9ecef;
            padding: 10px 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="my-4 text-center">User-Specific Data Example</h1>
        
        <?php if (!empty($error)): ?>
        <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        
        <?php if (!empty($message)): ?>
        <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
        <?php endif; ?>
        
        <?php if (isset($_SESSION['user_id'])): ?>
            <!-- User is logged in, show dashboard -->
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">User Dashboard</h5>
                    <a href="?logout=1" class="btn btn-sm btn-outline-danger">Logout</a>
                </div>
                <div class="card-body">
                    <div class="user-info">
                        <h4>Welcome, <?php echo htmlspecialchars($_SESSION['user_name']); ?>!</h4>
                        <p>User ID: <?php echo htmlspecialchars($_SESSION['user_id']); ?></p>
                    </div>
                    
                    <h5>Your Data</h5>
                    
                    <?php if (empty($spreadsheetId)): ?>
                        <div class="alert alert-warning">
                            Please set a Spreadsheet ID in config.php to view user data.
                        </div>
                    <?php elseif (empty($userData)): ?>
                        <div class="alert alert-info">
                            No data found for your user ID. Make sure your Google Sheet has:
                            <ul>
                                <li>A sheet named 'user_data'</li>
                                <li>A column named 'user_id'</li>
                                <li>Rows with your user ID (<?php echo htmlspecialchars($_SESSION['user_id']); ?>)</li>
                            </ul>
                        </div>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <?php foreach (array_keys($userData[0]) as $header): ?>
                                            <?php if ($header !== 'user_id'): ?>
                                                <th><?php echo htmlspecialchars($header); ?></th>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($userData as $row): ?>
                                        <tr>
                                            <?php foreach ($row as $key => $value): ?>
                                                <?php if ($key !== 'user_id'): ?>
                                                    <td><?php echo htmlspecialchars($value); ?></td>
                                                <?php endif; ?>
                                            <?php endforeach; ?>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="mb-0">Google Sheet Structure for User Data</h5>
                </div>
                <div class="card-body">
                    <p>For this example to work, your Google Sheet should have:</p>
                    
                    <h6>Sheet named 'user_data' with the following structure:</h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-bordered">
                            <thead>
                                <tr>
                                    <th>user_id</th>
                                    <th>data_field_1</th>
                                    <th>data_field_2</th>
                                    <th>data_field_3</th>
                                    <th>...</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>1</td>
                                    <td>Value 1</td>
                                    <td>Value 2</td>
                                    <td>Value 3</td>
                                    <td>...</td>
                                </tr>
                                <tr>
                                    <td>2</td>
                                    <td>Value 4</td>
                                    <td>Value 5</td>
                                    <td>Value 6</td>
                                    <td>...</td>
                                </tr>
                                <tr>
                                    <td>1</td>
                                    <td>Value 7</td>
                                    <td>Value 8</td>
                                    <td>Value 9</td>
                                    <td>...</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    
                    <p class="mt-3">The system will filter rows based on the 'user_id' column to show only data for the logged-in user.</p>
                </div>
            </div>
            
        <?php else: ?>
            <!-- User is not logged in, show login form -->
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Login</h5>
                </div>
                <div class="card-body">
                    <form method="post" action="" class="login-form">
                        <div class="mb-3">
                            <label for="username" class="form-label">Username</label>
                            <input type="text" class="form-control" id="username" name="username" required>
                        </div>
                        <div class="mb-3">
                            <label for="password" class="form-label">Password</label>
                            <input type="password" class="form-control" id="password" name="password" required>
                        </div>
                        <button type="submit" name="login" class="btn btn-primary">Login</button>
                    </form>
                    
                    <div class="mt-4">
                        <h6>Demo Users:</h6>
                        <ul>
                            <li>Username: 1, Password: pass1</li>
                            <li>Username: 2, Password: pass2</li>
                            <li>Username: 3, Password: pass3</li>
                        </ul>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">User-Specific Data Filtering</h5>
            </div>
            <div class="card-body">
                <p>This example demonstrates how to filter Google Sheets data based on the logged-in user:</p>
                
                <div class="alert alert-info">
                    <strong>How it works:</strong>
                    <ol>
                        <li>Log in with one of the demo users (1, 2, or 3)</li>
                        <li>The system retrieves all data from the 'user_data' sheet</li>
                        <li>It filters the data to show only rows where 'user_id' matches the logged-in user's ID</li>
                        <li>The filtered data is displayed in a table</li>
                    </ol>
                </div>
                
                <div class="alert alert-warning">
                    <strong>Important:</strong>
                    <ul>
                        <li>Make sure you've imported the sample_user_data.csv file into a sheet named "user_data" in your Google Spreadsheet.</li>
                        <li>The 'user_id' column in the user_data sheet should contain numeric values (1, 2, 3) that match the 'id' column in the users sheet.</li>
                    </ul>
                </div>
                
                <a href="index.php" class="btn btn-primary">Back to Main Page</a>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>