const recommendationData = {
    ventas: {
        title: "Aumentar Ventas",
        bestFormat: {
            type: "Carrusel de Productos",
            platform: "Instagram/Facebook",
            specs: "Múltiples imágenes 1080x1080px",
            description: "Ideal para mostrar productos, características y beneficios"
        },
        tips: [
            {
                title: "Stories con Link",
                platform: "Instagram/Facebook",
                description: "Formato vertical con CTA directo a la tienda"
            },
            {
                title: "Video Corto Demostrativo",
                platform: "TikTok/Reels",
                description: "60 segundos mostrando el producto en uso"
            },
            {
                title: "Pin de Producto",
                platform: "Pinterest",
                description: "Imagen vertical con precio y enlace directo"
            },
            {
                title: "Anuncio de Colección",
                platform: "Facebook",
                description: "Catálogo interactivo de productos"
            },
            {
                title: "Post con Etiquetas de Producto",
                platform: "Instagram Shop",
                description: "Contenido orgánico con tags de compra"
            }
        ]
    },
    seguidores: {
        title: "Ganar Seguidores",
        bestFormat: {
            type: "Reel/TikTok Viral",
            platform: "Instagram/TikTok",
            specs: "1080x1920px, 30-60 segundos",
            description: "Contenido entretenido y de valor que genera interacción"
        },
        tips: [
            {
                title: "Carrusel Educativo",
                platform: "Instagram/LinkedIn",
                description: "10 slides con tips o datos relevantes"
            },
            {
                title: "Challenge Participativo",
                platform: "TikTok",
                description: "Tendencia con hashtag propio"
            },
            {
                title: "Historia con Encuesta",
                platform: "Instagram",
                description: "Contenido interactivo que genera engagement"
            },
            {
                title: "Live Streaming",
                platform: "Instagram/TikTok",
                description: "Sesión en vivo respondiendo preguntas"
            },
            {
                title: "Contenido Behind-the-Scenes",
                platform: "Instagram Stories",
                description: "Mostrar el lado humano de la marca"
            }
        ]
    },
    trafico: {
        title: "Generar Tráfico Web",
        bestFormat: {
            type: "Link Post con Imagen",
            platform: "LinkedIn/Facebook",
            specs: "1200x630px",
            description: "Formato optimizado para clicks con imagen llamativa"
        },
        tips: [
            {
                title: "Blog Carousel",
                platform: "LinkedIn",
                description: "Slides que resumen el contenido del blog"
            },
            {
                title: "Story con Swipe Up",
                platform: "Instagram",
                description: "CTA directo al sitio web"
            },
            {
                title: "Pin Rico en Palabras Clave",
                platform: "Pinterest",
                description: "Imagen vertical optimizada para SEO"
            },
            {
                title: "Tweet con Link Card",
                platform: "Twitter",
                description: "Imagen destacada con meta descripción"
            },
            {
                title: "Video Teaser",
                platform: "Facebook",
                description: "Preview de contenido completo en web"
            }
        ]
    },
    engagement: {
        title: "Aumentar Engagement",
        bestFormat: {
            type: "Contenido Interactivo",
            platform: "Instagram/Facebook",
            specs: "Carrusel 1080x1080px",
            description: "Posts que invitan a la participación activa"
        },
        tips: [
            {
                title: "Encuestas en Stories",
                platform: "Instagram",
                description: "Preguntas que generan interacción"
            },
            {
                title: "Retos Comunitarios",
                platform: "TikTok",
                description: "Desafíos que motivan la participación"
            },
            {
                title: "Debates en Posts",
                platform: "LinkedIn/Twitter",
                description: "Preguntas abiertas que generan discusión"
            },
            {
                title: "Contenido User-Generated",
                platform: "Instagram",
                description: "Repost de contenido de seguidores"
            },
            {
                title: "Quiz Interactivo",
                platform: "Instagram Stories",
                description: "Preguntas y respuestas dinámicas"
            }
        ]
    },
    branding: {
        title: "Fortalecer Marca",
        bestFormat: {
            type: "Video de Marca",
            platform: "YouTube/Instagram",
            specs: "16:9 para YouTube, 1:1 para Feed",
            description: "Storytelling que conecta con la audiencia"
        },
        tips: [
            {
                title: "Serie de Historias",
                platform: "Instagram/Facebook",
                description: "Narrativa consistente sobre valores de marca"
            },
            {
                title: "Contenido Editorial",
                platform: "LinkedIn",
                description: "Artículos que establecen autoridad"
            },
            {
                title: "Branded Hashtag Challenge",
                platform: "TikTok",
                description: "Movimiento social alineado con la marca"
            },
            {
                title: "Behind-the-Scenes",
                platform: "Instagram Stories",
                description: "Contenido auténtico que humaniza la marca"
            },
            {
                title: "Colaboraciones Estratégicas",
                platform: "Múltiples",
                description: "Contenido conjunto con marcas afines"
            }
        ]
    }
};

function displayRecommendations(objective) {
    const resultsContainer = document.querySelector('.results-container');
    const data = recommendationData[objective];
    
    if (!data) {
        resultsContainer.classList.remove('show');
        return;
    }

    let resultsHTML = `
        <div class="recommendation-card highlight">
            <h3>Formato Recomendado: ${data.bestFormat.type}</h3>
            <p><strong>Plataforma:</strong> ${data.bestFormat.platform}</p>
            <p><strong>Especificaciones:</strong> ${data.bestFormat.specs}</p>
            <p><strong>¿Por qué?</strong> ${data.bestFormat.description}</p>
        </div>
        <h3>Top 5 Recomendaciones Adicionales</h3>
    `;

    data.tips.forEach(tip => {
        resultsHTML += `
            <div class="recommendation-card">
                <h3>${tip.title}</h3>
                <span class="platform-tag">${tip.platform}</span>
                <p>${tip.description}</p>
            </div>
        `;
    });

    resultsContainer.innerHTML = resultsHTML;
    resultsContainer.classList.add('show');
}

document.getElementById('objectiveSelect').addEventListener('change', (e) => {
    const selectedObjective = e.target.value;
    if (selectedObjective) {
        displayRecommendations(selectedObjective);
    } else {
        document.querySelector('.results-container').classList.remove('show');
    }
});

// Banner rotation
(function(){
    var current = 0;
    var banners = document.querySelectorAll("#banner-rotator a");
    if (banners.length > 0) {
        banners[0].style.display = "block";
        setInterval(function(){
            banners[current].style.display = "none";
            current = (current + 1) % banners.length;
            banners[current].style.display = "block";
        }, 7000);
    }
})();